/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CenteredArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import org.apache.commons.lang3.NotImplementedException;

public class VerticalCylinderArea
extends CenteredArea {
    private class_2338 centerTopPos;
    private int distance;
    private int radius;

    public VerticalCylinderArea(class_2338 centerBottomPos, class_2338 scopePos) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = new class_2338(centerBottomPos.method_10263(), scopePos.method_10264(), centerBottomPos.method_10260());
        this.radius = AreaUtil.distanceManhattan(centerBottomPos, new class_2338(scopePos.method_10263(), centerBottomPos.method_10264(), scopePos.method_10260()));
        this.distance = AreaUtil.distanceManhattan(centerBottomPos, this.centerTopPos);
    }

    public VerticalCylinderArea(class_2338 centerBottomPos, int radius, int distance) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = centerBottomPos.method_10069(0, distance, 0);
        this.radius = radius;
        this.distance = distance;
    }

    public VerticalCylinderArea(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    @Override
    public class_2382 getCenter() {
        return new class_2382(this.center.method_10263(), this.center.method_10264(), this.center.method_10260());
    }

    @Override
    public boolean contains(class_2338 pos) {
        class_2338 dist = this.centerTopPos.method_10059((class_2382)this.center);
        boolean b1 = this.multiply(pos.method_10059((class_2382)this.center), dist).method_10265((class_2382)class_2338.field_10980) >= 0;
        boolean b2 = this.multiply(pos.method_10059((class_2382)this.centerTopPos), dist).method_10265((class_2382)class_2338.field_10980) <= 0;
        boolean isBetweenPlanes = b1 && b2;
        class_2338 crossProduct = pos.method_10059((class_2382)this.center).method_10075((class_2382)dist);
        double distance = AreaUtil.length(crossProduct) / (double)AreaUtil.distanceManhattan(this.centerTopPos, this.center);
        boolean isInsideSurface = distance <= (double)this.radius;
        return isBetweenPlanes && isInsideSurface;
    }

    @Override
    public Set<class_2338> getHull() {
        throw new NotImplementedException("ChunkArea.getHull() not implemented yet");
    }

    @Override
    public Set<class_2338> getFrame() {
        return Set.of();
    }

    @Override
    public Set<class_2338> getMinimalOutline() {
        return Set.of();
    }

    public int getDistance() {
        return this.distance;
    }

    public int getRadius() {
        return this.radius;
    }

    public class_2338 multiply(class_2338 p1, class_2338 p2) {
        return new class_2338(p1.method_10263() * p2.method_10263(), p1.method_10264() * p2.method_10264(), p1.method_10260() * p2.method_10260());
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10569("radius", this.radius);
        nbt.method_10569("height", this.distance);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.distance = nbt.method_10550("radius");
        this.radius = nbt.method_10550("height");
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    public String toString() {
        return "Cylinder " + AreaUtil.blockPosStr(this.center) + " with radius " + this.radius + " and height " + this.distance + ".";
    }
}

